package jamezo97.clonecraft.network;

import jamezo97.clonecraft.block.TileEntityCentrifuge;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetworkManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.world.World;
import cpw.mods.fml.relauncher.Side;

public class Handler1SpinCentrifuge extends Handler{

	public Handler1SpinCentrifuge(){
		
	}
	@Value(id = 0)
	int xCoord;
	@Value(id = 1)
	int yCoord;
	@Value(id = 2)
	int zCoord;
	@Value(id = 3)
	int windowId;
	public Handler1SpinCentrifuge(int xCoord, int yCoord, int zCoord, int windowId){
		this.xCoord = xCoord;
		this.yCoord = yCoord;
		this.zCoord = zCoord;
		this.windowId = windowId;
	}
	
	@Override
	public void handle(Side side, INetworkManager manager, EntityPlayer player) {
		World world = player.worldObj;
		if(world != null){
			TileEntity entity = world.getBlockTileEntity(xCoord, yCoord, zCoord);
			if(entity != null && entity instanceof TileEntityCentrifuge){
				TileEntityCentrifuge tec = ((TileEntityCentrifuge)entity);
				if(tec.canSpin() && (tec.isBurning() || TileEntityFurnace.getItemBurnTime(tec.items[4])>0)){
					tec.spinPressed = true;
				}
			}
		}
	}

}
